function varargout = viewfactors(varargin)
% VIEWFACTORS M-file for viewfactors.fig
%      VIEWFACTORS, by itself, creates a new VIEWFACTORS or raises the existing
%      singleton*.
%
%      H = VIEWFACTORS returns the handle to a new VIEWFACTORS or the handle to
%      the existing singleton*.
%
%      VIEWFACTORS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in VIEWFACTORS.M with the given input arguments.
%
%      VIEWFACTORS('Property','Value',...) creates a new VIEWFACTORS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before viewfactors_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to viewfactors_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help viewfactors

% Last Modified by GUIDE v2.5 21-Oct-2012 10:51:36

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @viewfactors_OpeningFcn, ...
                   'gui_OutputFcn',  @viewfactors_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before viewfactors is made visible.
function viewfactors_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to viewfactors (see VARARGIN)


% Choose default command line output for viewfactors
handles.output = hObject;
breakthis=0;
handles.breakthis=breakthis;
axes(handles.axes2);
        imshow('logo_fsi.png');

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes viewfactors wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = viewfactors_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in popupmenu1.
function popupmenu1_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val=get(hObject,'Value');
str=get(hObject,'String');
 %obrazek
switch str{val}
    case 'Kvdr'
        axes(handles.axes1);
        imshow('Kvdr.png');
    
    case 'Felicie bez stinn'
        axes(handles.axes1);
        imshow('auto.png');
    case 'Kvdr se stnnm'
        axes(handles.axes1);
        imshow('Krychle_v_kvadru_jemne.png');
    case 'Shapirv test'
        axes(handles.axes1);
        imshow('Shapiro.png');  
    case 'Felicie se stnnm'
        axes(handles.axes1);
        imshow('Felicia3D.png');      
end
    

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu1 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu1


% --- Executes during object creation, after setting all properties.
function popupmenu1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

 %podle toho ktery byl vybrany
 % inicializace dat
val=get(handles.popupmenu1,'Value');
str=get(handles.popupmenu1,'String');
switch str{val}
    case 'Kvdr'
          vf=load('vf_krychle.mat');
          jmenosouboru='Kvadr_extended.nas';  
    case 'Felicie bez stinn'
        vf=load('vf_krychle.mat');
        jmenosouboru='Auto_extended.nas';
    case 'Kvdr se stnnm'
         vf=load('vf_krychle_v_kvadru.mat');
         jmenosouboru='Krychle v kvadru-normalni_extended.nas';
    case 'Shapirv test'
        vf=load('vf_shapiro.mat'); 
        jmenosouboru='shapiro_normal_extended.nas'; 
    case 'Felicie se stnnm'
        vf=load('vf_felda.mat');  
        jmenosouboru='Felicia3D_extended.nas'; 
end

if val==1
her = msgbox('Vyberte geometrii v menu nad tlatkem Zobrazit tabulku','Pozor','warn');
    
else   
    
    

%vytvoreni figure
figurehandle=figure('NumberTitle','off');
set(figurehandle,'Name',str{val});
set(figurehandle,'Menubar','none');
    [pocetploch l]=size(vf.vfk);
%popis ploch

formatsouboru=true;
names=inicializace(jmenosouboru,formatsouboru);

%tabulka
scrsz = get(0,'ScreenSize');
set(figurehandle,'Position',[100 scrsz(4)-pocetploch*30-200 pocetploch*50+200 pocetploch*30+100 ])
for i=1:pocetploch
     handlesstaticH=uicontrol(figurehandle,'Style', 'Text', 'String', i,...
    'Position', [(100+i*50) (pocetploch*30+10) 50 20] );
    handlesstaticV=uicontrol(figurehandle,'Style', 'Text', 'String', i,...
    'Position', [(80) (pocetploch*30-i*25) 50 20] );

    for j=1:pocetploch
        jmenobunky=strcat(num2str(i),' ',num2str(j));
        %handles jednotlivych editu

        handlesedit(i,j)=uicontrol(figurehandle,'Style', 'edit', 'String', num2str(vf.vfk(i,j)),...
    'Position', [(100+j*50) (pocetploch*30-i*25) 50 20] );
    end
end

for k=1:ceil(pocetploch/2)
handlesplochy=uicontrol(figurehandle,'Style', 'Text', 'String', strcat(num2str(k),'-',names(k)),...
    'Position', [(0+k*80) (pocetploch*30+70) 80 30] );
end
for k=ceil(pocetploch/2)+1:pocetploch
    
handlesplochy=uicontrol(figurehandle,'Style', 'Text', 'String', strcat(num2str(k),'-',names(k)),...
    'Position', [(0+(k-ceil(pocetploch/2))*80) (pocetploch*30+40) 80 30] );
end
end
% --- Executes when figure1 is resized.
function figure1_ResizeFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


[jmenosouboru,PathName] = uigetfile('*.nas','Vyberte prostorovou s generovanou pomoc STAR-CCM+');
%predani dat mezi callbacky


handles.jmenosouboru=jmenosouboru;
set(handles.export_vlastni,'Enable','off');
handles.PathName=PathName;
guidata(hObject, handles);

if jmenosouboru~=0
if strcmp(jmenosouboru(length(jmenosouboru)-3:length(jmenosouboru)),'.nas')==0

    her = msgbox('patn formt vstupnho souboru. Vyberte soubor .nas','Pozor','warn');
    set(handles.pushbutton3,'Enable','off');
else
   set(handles.pushbutton3,'Enable','on')   ;     
end
    else
    end





% --- Executes on button press in radiobuttonEXT.
function radiobuttonEXT_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonEXT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(handles.radiobuttonNORM,'Value')==1
    set(handles.radiobuttonNORM,'Value',0)
    set(handles.radiobuttonEXT,'Value',1);
end
% Hint: get(hObject,'Value') returns toggle state of radiobuttonEXT


% --- Executes on button press in radiobuttonNORM.
function radiobuttonNORM_Callback(hObject, eventdata, handles)
% hObject    handle to radiobuttonNORM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(handles.radiobuttonEXT,'Value')==1
    set(handles.radiobuttonEXT,'Value',0)
    set(handles.radiobuttonNORM,'Value',1);
end
% Hint: get(hObject,'Value') returns toggle state of radiobuttonNORM


% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%cely kod
handles.breakthis=0;
guidata(hObject, handles);
PathName=handles.PathName;
jmenosouboru=handles.jmenosouboru;
celejmeno=strcat('',PathName,jmenosouboru,'' )

chyba=0;
if get(handles.radiobuttonNORM,'Value')==1
    formatsouboru=0;
elseif get(handles.radiobuttonEXT,'Value')==1
    formatsouboru=1;
else
    her = msgbox('Vyberte typ vstupn geometrie NORMAL/EXTENDED','Pozor','warn');
    chyba=1;
end


   
try
    if chyba==0     %nic nevybrano
    hw=waitbar(0,'Inicializace vpotu. ekejte prosm..');
    set(hw,'CloseRequestFcn','');
    [names,vfk]=Vlastnivstup(celejmeno,formatsouboru);
    set(hw,'CloseRequestFcn','closereq');
    close(hw);
    end

catch
    set(hw,'CloseRequestFcn','closereq');
    close(hw);
    her = msgbox('Vstupn soubor nen v platnm formtu nebo byl pate zvolen typ vstupn geometrie. Natte znovu sprvn vstupn data.','Chyba vstupnho souboru','warn');
    chyba=1;
end
  %spravne vybrano .nas a normal/extended
if chyba==0%vytvoreni figure
   %umozni export
    handles.vfk=vfk;
    guidata(hObject, handles);
    set(handles.export_vlastni,'Enable','on');
    
    %tisk figury
figurehandle=figure('NumberTitle','off');
set(figurehandle,'Name','Vlastn vpoetn s');
set(figurehandle,'Menubar','none');
[pocetploch l]=size(vfk);

%tabulka
scrsz = get(0,'ScreenSize');
set(figurehandle,'Position',[100 scrsz(4)-pocetploch*30-200 pocetploch*50+200 pocetploch*30+100 ])
%vypis tabulky
for i=1:pocetploch
    handlesstaticH=uicontrol(figurehandle,'Style', 'Text', 'String', i,...
        'Position', [(100+i*50) (pocetploch*30+10) 50 20] );
    handlesstaticV=uicontrol(figurehandle,'Style', 'Text', 'String', i,...
        'Position', [(80) (pocetploch*30-i*25) 50 20] );
    %vypishodnot
    for j=1:pocetploch
        
        %handles jednotlivych editu
        
        handlesedit(i,j)=uicontrol(figurehandle,'Style', 'edit', 'String', num2str(vfk(i,j)),...
            'Position', [(100+j*50) (pocetploch*30-i*25) 50 20] );
    end
end

%vypis legendy
for k=1:ceil(pocetploch/2)
    handlesplochy=uicontrol(figurehandle,'Style', 'Text', 'String', strcat(num2str(k),'-',names(k)),...
        'Position', [(0+k*80) (pocetploch*30+70) 80 30] );
end
for k=ceil(pocetploch/2)+1:pocetploch
    
    handlesplochy=uicontrol(figurehandle,'Style', 'Text', 'String', strcat(num2str(k),'-',names(k)),...
        'Position', [(0+(k-ceil(pocetploch/2))*80) (pocetploch*30+40) 80 30] );
end    
else
end


% --- Executes on button press in exportDemo.
function exportDemo_Callback(hObject, eventdata, handles)
% hObject    handle to exportDemo (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
 %podle toho ktery byl vybrany
 % inicializace dat
val=get(handles.popupmenu1,'Value');
str=get(handles.popupmenu1,'String');
switch str{val}
    case 'Kvdr'
          vf=load('vf_krychle.mat');
          jmenosouboru='Kvadr_extended.nas';  
          a=dataset(vf.vfk);
          FALSE=false;
          export(a,'XLSfile','Kvdr.xls','WriteVarNames',FALSE);
          her = msgbox('Export probhl spn','Export .XLS','warn');
    case 'Felicie bez stinn'
        vf=load('vf_krychle.mat');
        jmenosouboru='Auto_extended.nas';
        a=dataset(vf.vfk);
          FALSE=false;
          export(a,'XLSfile','Felicie bez stinn.xls','WriteVarNames',FALSE);
          her = msgbox('Export probhl spn','Export .XLS','warn');
    case 'Kvdr se stnnm'
         vf=load('vf_krychle_v_kvadru.mat');
         jmenosouboru='Krychle v kvadru-normalni_extended.nas';
          a=dataset(vf.vfk);
          FALSE=false;
          export(a,'XLSfile','Kvdr se stnnm.xls','WriteVarNames',FALSE);
          her = msgbox('Export probhl spn','Export .XLS','warn');
    case 'Shapirv test'
        vf=load('vf_shapiro.mat'); 
        jmenosouboru='shapiro_normal_extended.nas'; 
         a=dataset(vf.vfk);
          FALSE=false;
          export(a,'XLSfile','Shapirv test.xls','WriteVarNames',FALSE);
          her = msgbox('Export probhl spn','Export .XLS','warn');
    case 'Felicie se stnnm'
        vf=load('vf_felda.mat');  
        jmenosouboru='Felicia3D_extended.nas'; 
         a=dataset(vf.vfk);
          FALSE=false;
          export(a,'XLSfile','Felicie se stnnm.xls','WriteVarNames',FALSE);
          her = msgbox('Export probhl spn','Export .XLS','warn');
end

if val==1
her = msgbox('Vyberte geometrii v menu nad tlatkem Zobrazit tabulku','Pozor','warn');
    
else   
end
    
   

% --- Executes on button press in STOPbutton.
function STOPbutton_Callback(hObject, eventdata, handles)
% hObject    handle to STOPbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
breakthis=1;
handles.breakthis=breakthis;
% 

guidata(hObject, handles);

   


% --- Executes on button press in export_vlastni.
function export_vlastni_Callback(hObject, eventdata, handles)
% hObject    handle to export_vlastni (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
          a=dataset(handles.vfk);
          FALSE=false;
          jmeno=handles.jmenosouboru(1:length(handles.jmenosouboru)-4);
          jmenoexcel=strcat(jmeno,'.xls');
          export(a,'XLSfile',jmenoexcel,'WriteVarNames',FALSE);
          her = msgbox('Export probhl spn','Export .XLS','warn');
